<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;

class Province extends Model
{
    use HasFactory;

    protected $fillable=['nome',  'codigo', 'latitude', 'longitude', 'precision', 'user_id', 'entidade_id'];

    
    //Pertence a uma entidade
    public function entidade():BelongsTo
    {
        return $this->belongsTo(Entidade::class);
    }

    // tem pode um responsável
    public function Users():BelongsTo
    {
        return $this->BelongsTo(User::class);
    }

    

}
